


class Project_XP < Project




  # Cre une liste vierge servant  noter les modifications apportes aux maps
  def modif_creer


    @modifs = {}

    liste = lister_rm

    # Ajout des infos sur les maps
    for file in liste
      modif_update_file(file, false)
    end


    modif_ecrire

  end



  def modif_ecrire
    
    dat = $e.dossier_dmk(F_MODIF)

    DA::marshal_write(dat, $dmk_version)
    DA::marshal_write_add(dat, @modifs)
  end


  # Met  jour le hash des modfications
  def modif_update_file(path, modif)
    map = File.basename(path)
    # On rcupre le crc32 du fichier de la map
    crc32 = DA::file_crc32(path)
    modif_update_hash(map, modif, crc32)
  end

  def modif_update_map(map, modif)
    path = $e.dossier_rm(map)
    # On rcupre le crc32 du fichier de la map
    crc32 = DA::file_crc32(path)
    modif_update_hash(map, modif, crc32)
  end

  def modif_update_hash(map, modif, time)
    #pa map, modif, time
    @modifs.update({map => [modif, time]})
    modif_ecrire
  end


  def modif_delete_file(file, ext=true)
    map = File.basename(file)
    if ext == true
      modif_delete_hash(map)
    else
      # On rcupre la liste des fichiers ayant ce nom de fichier
      list = modif_files(file)
      for file in list
        modif_delete_file(file)
      end
    end
  end


  def modif_delete_map(map)
    modif_delete_hash(map)
  end

  def modif_delete_hash(map)
    @modifs.delete(map)
    modif_ecrire
  end


  # Renvoie la liste de tous les fichiers prsents dans le fichier modif
  def modif_files(reg_nom=nil)
    if reg_nom == nil
      return @modifs.keys
    end
    list = @modifs.keys
    if reg_nom.is_a?(Regexp) == true
      list.keep_reg!(reg_nom)
      return list
    end
    # reg_nom est une string
    lis = []
    for nom in list
      lis << nom if reg_nom.egal_short(nom) == true
    end
    return lis
  end


  


  def modif_lire
    dat = $e.dossier_dmk(F_MODIF)

    # On regarde si le fichier des modifications existe
    if DA::file_exists?(dat) == false
      # Si le fichier n'existe pas, on le cre
      modif_creer
    end


    
    begin
      version = DA::marshal_read(dat)
    rescue DAE_Marshal_Open => e
      raise(DMKE_Mod_Open.new(dat))
    rescue DAE_Marshal_Read => e
      raise(DMKE_Mod_Read.new(dat))
    end

    #pa "v", version
    if version >= "4.3"
      @modifs = modif_lire_4_3
    end

  end


  def modif_lire_4_3
    dat = $e.dossier_dmk(F_MODIF)
    begin
      infos = DA::marshal_read_pos(dat, 1)
    rescue DAE_Marshal_Read_Pos => e
      raise(DMKE_Mod_Read.new(dat))
    end
    return infos

  end

  # Indique si le fichier a t modifie ou non
  #  path : chemin du fichier
  def modif_fichier?(path)
    begin
      crc32 = DA::file_crc32(path)
    rescue DA::DAE_File_Not_Found
      modif_delete_file(path)
      modif_ecrire
      raise(DMKW_Mod_No_File.new(path))
    end
    #p @modifs, time_irl
    file_name = File.basename(path)
    # On regarde si le fichier est prsent
    if @modifs.include?(file_name) == false
      modif_update_file(path, true)
      return false
    end
    crc32_save = @modifs[file_name][1]
    #pa path, time_irl, time_save
    return crc32 != crc32_save
  end

  
  # Indique si le fichier DMK a t modifie ou non
  #  path : chemin du fichier
  def modif_fichier_dmk?(path)
    file_name = File.basename(path)
    # On regarde si le fichier est prsent
    if @modifs.include?(file_name) == false
      modif_update_file(file_name, true)
      return false
    end
    modif = @modifs[file_name][0]
    return modif
  end



end